import javax.swing.*;
import com.phidgets.*;
import com.phidgets.event.*;
import java.awt.*;
import java.awt.event.*;

public class JEventViewer extends JFrame {
	private JTextArea text;
	private InterfaceKitPhidget	interfaceKit;
	private int pressIndex	= 1;
	
	public static void main(String[] args) {
		JEventViewer view = new JEventViewer();
		view.pack();
		view.setVisible( true );
		view.openIntfcKit();
	}
	
	public JEventViewer() {
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				closeIntfcKit(); }
		});
		text = new JTextArea(20, 60);
		text.setLineWrap(true);
		JScrollPane p= new JScrollPane(text, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		Container c= getContentPane();
		c.add(p, BorderLayout.CENTER);
	}
	
	private void openIntfcKit() {
		try {
			interfaceKit = new InterfaceKitPhidget();
			interfaceKit.addErrorListener(new ErrorListener() {
				public void error(ErrorEvent ee) {
					System.out.println("Error event for " + ee);
				}
			});
			interfaceKit.addSensorChangeListener(new SensorChangeListener() {
				public void sensorChanged(SensorChangeEvent se) {
					updateSensor(se);
				}
			});
			interfaceKit.openAny();
			System.out.println("Waiting for PressureSensor attachment...");
			interfaceKit.waitForAttachment();
			interfaceKit.setRatiometric(true);
			while (!interfaceKit.getRatiometric());
		} catch (PhidgetException pe) {
			System.err.println(pe);
		}
	}

	private void updateSensor(SensorChangeEvent se) {
		append(se.toString() + "\n" );
	}
	
	private void append( final String s ) {
		// Your code here:
	    // Create an object of type Runnable
	    //   Write its run() method to text.append( s );
	    // Call invokeLater()
	}

	private void closeIntfcKit() {
		System.out.println("Closing...");
		try {
			interfaceKit.close(); }
		catch (PhidgetException pe) { 
			System.err.println(pe); }
		interfaceKit = null;
		System.exit(0);
	}
}